#include "utils.h"
#include "gndefs.h"
#include <stdint.h>
#include <string.h>

int32_t ConvertColourCorrectionValue(int32_t nColourCorrection) {
    // Converts the values that are shown the user via the PPD file to the
    // internal values that the driver uses.

    // Note that this is currently only really valid for the Pronto 100

    switch (nColourCorrection) {
        case 0:
            return UICBVAL_ColourCorrection_None;
        case 1:
            return UICBVAL_ColourCorrection_ICC_Internal;
        case 2:
            return UICBVAL_ColourCorrection_Perceptual;
        case 3:
            return UICBVAL_ColourCorrection_Saturation;
        case 4:
            return UICBVAL_ColourCorrection_RelColorimetric;
        case 5:
            return UICBVAL_ColourCorrection_AbsColorimetric;
    }

    return UICBVAL_ColourCorrection_None;
}

/* mc_strncpy
 *
 * A magicard version of strncpy, but ensures the destination is null
 * terminated.
 * This is intended to be a safer strcpy but it trades off no buffer
 * overruns for potential truncation of the copy, if dest
 * is smaller than source.
 *
 * dest - char array to copy to.
 * source - char array to copy from.
 * num_bytes - number of bytes to copy. Should be the size of dest, in bytes.
 */
void mc_strncpy(char dest[], const char *source, const size_t num_bytes) {

    if (num_bytes > 0) {
        strncpy(dest, source, num_bytes);
        dest[num_bytes - 1] = '\0';
    }
    return;
}

int32_t CalculatePrintHeadPower_YMC(PSETTINGS psettings) {

    // 50: no adjustment (power adjust = 0).
    // 0-50: range -32768 to 0.
    // 50-100: range 0 to 10000

    // Multiplier for values less that 50
    float multiplier = 655.34F;

    // For values above 50 use this multiplier to get values from 0 to 10000
    if (psettings->nPrintHeadPower_YMC > 50) {
        multiplier = 200;
    }

    int power =
            (int)((float)(psettings->nPrintHeadPower_YMC - 50) * multiplier);

    return power;
}
