#ifndef RP2_MAG_ENCODE_H
#define RP2_MAG_ENCODE_H
#include <stdbool.h>
#include <stdint.h>

void    mag_encoder_setup_5bit_look_up(void);
int32_t mag_encoder_setup_5bit_data(char *             input_data,
                                    uint8_t *          output_data,
                                    const int          lead,
                                    const bool         bAddEndSentinel);

void    mag_encoder_setup_7bit_look_up(void);
int32_t mag_encoder_setup_7bit_data(char *     input_data,
                                    uint8_t *  output_data,
                                    const int  lead,
                                    const bool bAddEndSentinel);

int32_t mag_encoder_setup_8bit_data(char *     input_data,
                                    uint8_t *  output_data,
                                    const int  lead,
                                    const bool bAddEndSentinel);

int32_t mag_encoder_setup_4bit_data(char *input_data, uint8_t *output_data);

int32_t mag_encoder_setup_1bit_data(char *input_data, uint8_t *output_data);

#endif /* RP2_MAG_ENCODE_H */
