#include "magigen.h"

/*
 * Definitions for magnetic strip encoding tracks
 * Those values are based from ISO 7810, 7811 and 7813
 * Character codes are all in UNICODE
 */

#define CHAR_TILDE 0x7e // Tilde
#define CHAR_COMMA 0x2c // Comma

// Maximum numbers of character (incl. SS and ES)
#define MAX_NUMCHAR_TRACK0 MAG_MAXBUFFERNUM
#define MAX_NUMCHAR_TRACK1 MAG_MAXBUFFERNUM // was 78
#define MAX_NUMCHAR_TRACK2 MAG_MAXBUFFERNUM // was 39
#define MAX_NUMCHAR_TRACK3 MAG_MAXBUFFERNUM // was 106
#define MAX_NUMCHAR_TRACK4 MAG_MAXBUFFERNUM

// ISO sentinels for each track
#define ISO_STARTSENTINEL_TRACK1 0x0025 // Percent sign
#define ISO_STARTSENTINEL_TRACK2 0x003b // Semi colon
#define ISO_STARTSENTINEL_TRACK3 0x003b // Semi colon
#define ISO_ENDSENTINEL 0x003f          // Question mark - for all tracks

// JIS sentinels
#define JIS_STARTSENTINEL 0x007f
#define JIS_ENDSENTINEL 0x007f

// Supported character range
#define MIN_CHAR_TRACK0 0x0020     // Space
#define MAX_CHAR_TRACK0 0x007f     // DEL
#define MIN_CHAR_TRACK1 0x0020     // Space
#define MAX_CHAR_ISO_TRACK1 0x005f // Underscore
#define MAX_CHAR_JIS_TRACK1 0x007f // DEL
#define MIN_CHAR_TRACK2 0x0030     // Digit 0
#define MAX_CHAR_TRACK2 0x003f     // Question mark
#define MIN_CHAR_TRACK3 0x0030     // Digit 0
#define MAX_CHAR_TRACK3 0x003f     // Question mark

// Track index in character
#define INDEX_CHAR_TRACK0 0x0030 // Digit 0
#define INDEX_CHAR_TRACK1 0x0031 // Digit 1
#define INDEX_CHAR_TRACK2 0x0032 // Digit 2
#define INDEX_CHAR_TRACK3 0x0033 // Digit 3
#define INDEX_CHAR_TRACK4 0x0034 // Digit 4

#define MAG_DENSITY_210 210
#define MAG_DENSITY_75 75

#define MAG_BITPERCHAR_7 7
#define MAG_BITPERCHAR_5 5

#define MAG_COERCIVITY_LOW     0
#define MAG_COERCIVITY_HIGH    1
#define MAG_COERCIVITY_MEDIUM  2

/*
 * Valid magnetic encoding commands
 *
 * These strings are used in LocateStartSentinelPosition() for finding
 * the correct position for a missing start sentinel.
 *
 * Please note that these should all be uppercase
 */
#define MAX_COMMAND_SIZE 5
#define JIS2_COMMAND "JIS2"

void InitializeMagneticEncodeTrackInfo(PDEVDATA pdev, // Pointer to our PDEV
                                       struct settings_ *settings);

bool ValidMagDataChar(LPMAGTRACKINFO lpTrackInfo, ///< Pointer to the track info
                      uint8_t        CharIn ///< Character for mag encoding
                      );

int RecordMagneticEncodeTrackInfo(PDEVDATA          pdev, // Pointer to our PDEV
                                  char *            lpStrIn,
                                  struct settings_ *settings);

bool JIS2CommandInString(const MAGTRACKINFO *lpTrackInfo);

void PerformPostProcessing(LPMAGTRACKINFO lpTrackInfo,
                           struct settings_ *settings);
