
#ifndef COLORTAB_STRUCTURES_H
#define COLORTAB_STRUCTURES_H

// colour table structures..
// START_COLOUR_TABLE
// HSV->CMYK
typedef struct COLOUR_MATCH_TABLE {
    uint16_t H;
    uint16_t S;
    uint16_t V;
    uint8_t  C;
    uint8_t  M;
    uint8_t  Y;
    uint8_t  K;
} COLOURMATCHTABLE;

typedef COLOURMATCHTABLE *PCOLOURMATCHTABLE;

typedef struct {
    double r; // percent
    double g; // percent
    double b; // percent
} rgb;

typedef struct {
    double h; // angle in degrees
    double s; // percent
    double v; // percent
} hsv;

typedef struct _CMYK {
    float C;
    float M;
    float Y;
    float K;
} CMYK;

#endif // COLORTAB_STRUCTURES_H
