/***************************************************************************/
/**                                                                       **/
/**                            MAGICARD LTD                               **/
/**                                                                       **/
/***************************************************************************/
/**                                                                       **/
/**  PROJECT      : Magicard Driver                                       **/
/**                                                                       **/
/**  MODULE NAME  : cmnDef.h                                              **/
/**                                                                       **/
/**  SIN No.      : 2076                                                  **/
/**                                                                       **/
/**  COPYRIGHT    : Magicard Ltd				                          **/
/**                                                                       **/
/***************************************************************************/

#ifndef __CMNDEF_H__
#define __CMNDEF_H__


// Used in several functions to know which plane we are processing
#define PLANE_Y 0
#define PLANE_M 1
#define PLANE_C 2
#define PLANE_K 3
#define PLANE_HALO 4

#define PLANE_MAX (PLANE_HALO + 1) // This is used for allocating memory

// Fixed value : we always send out scanlines to the device as this width
#define OUTPUT_DATA_WIDTH_RIO 504          // Rio/Tango 2 Data Width
#define OUTPUT_DATA_WIDTH_ALTO 576         // Alto/Opera/Tempo Data Width
#define OUTPUT_DATA_WIDTH_HELIX 1036       // Helix Data Width
#define OUTPUT_DATA_WIDTH_PRO360 642       // pro2 Data Width
#define OUTPUT_DATA_WIDTH_PRO360_CR79 615  // pro2 cr79 Data Width
#define OUTPUT_DATA_HEIGHT_PRO360 1013     // pro2 Data Height
#define OUTPUT_DATA_HEIGHT_PRO360_CR79 991 // pro2 cr79 Data Height

#define MAG_TRACK_NONE -1
#define FIRST_MAG_TRACK MAG_TRACK_INDEX1
#define LAST_MAG_TRACK MAG_TRACK_INDEX3

//#define MAG_MAXBUFFERNUM  256  //RJE 22/1/09
#define MAG_MAXBUFFERNUM 750

// typedef struct tagMAGTRACKINFO {
//     bool     bFoundSS;    // true = Found the start sentinel
//     bool     bFoundES;    // true = Found the end sentinel
//     bool     bComplete;   // true = Saved full track data in TrackData
//     bool     bBufferFull; // true = TrackData has max. no. of byte characters.
//     char     TrackData[MAG_MAXBUFFERNUM]; ///< Recorded magnetic encoding data.
//     uint32_t ulTrackLength;               // Length from SS to ES in TrackData
//     // Members below will be dependent on track number.
//     // See MagEncd.C InitializeMagneticEncodeTrackInfo()
//     uint16_t wStartSentinel; // Start Sentinel (SS) for the track
//     uint16_t wEndSentinel;   // End Sentinel (ES) for the track
//     bool     bSSAutoInsert;  // Auto Insert setting for SS
//     bool     bESAutoInsert;  // Auto Insert setting for ES
//     uint16_t wMinCharCode;   // Minimum character code for the track.
//     uint16_t wMaxCharCode;   // Maxmum character code for the track.
//     bool bHexData; // true = Bits per Char is 4 so do not perform range checking
//                    // on data as this is performed on output
//     uint32_t ulMaxTrackLen; // Max. no. of characters between SS and ES
//     uint16_t wBitsPerChar;  // Bits per char defaulting to UI setting and
//                             // modified if passed in text string
//     uint16_t wBitsPerInch;  // Bits per inch defaulting to UI setting and
//                             // modified if passed in text string
//     uint16_t wCoercivity; // Coercivity defaulting to UI setting and modified if
//                           // passed in text string
//     bool *pValidCharList; // List of characters to be used between SS and ES
// } MAGTRACKINFO;
// typedef MAGTRACKINFO *PMAGTRACKINFO, FAR *LPMAGTRACKINFO;

// Index for the buffers to be used detect adjacent colour option
#define BUFFER_PREV 0
#define BUFFER_CURR 1
#define BUFFER_NEXT 2

#endif //__CMNDEF_H__
